# 📻 RadioApp - Aplicación de Radio Streaming Completa

Una aplicación Android profesional de radio con panel administrativo web para gestionar todos los aspectos de tu estación en tiempo real.

![Version](https://img.shields.io/badge/version-1.0.0-blue)
![License](https://img.shields.io/badge/license-MIT-green)
![Platform](https://img.shields.io/badge/platform-Android%2021%2B-brightgreen)

---

## 🎯 Características Principales

### 📱 Aplicación Android

✅ **Reproductor de Radio Moderno**
- Soporte para Shoutcast e Icecast
- Controles de reproducción intuitivos
- Indicador de estado en tiempo real

✅ **Interfaz Personalizable**
- Colores primarios y secundarios configurables
- Logo de estación dinámico
- Tema oscuro moderna y responsiva

✅ **Información en Vivo**
- Nombre de la estación
- Canción/Programa actual
- Estado de transmisión

✅ **Integración de Redes Sociales**
- Enlaces a Facebook, Instagram, TikTok, WhatsApp
- Actualizables desde el panel

✅ **Pantalla de Carga (Splash Screen)**
- Logo personalizado
- Animación de carga elegante

### 🌐 Panel Administrativo Web

✅ **Gestión Completa**
- Cambiar URL del stream en tiempo real
- Editar información de estación
- Personalizar colores de la app
- Gestionar enlaces de redes sociales
- Subir/cambiar logo

✅ **Seguridad**
- Autenticación con contraseña encriptada
- Control de sesiones
- Registro de cambios
- Protección contra intentos fallidos

✅ **Base de Datos**
- MySQL/MariaDB
- Historial de cambios
- Tablas de usuarios
- Logs de acceso

✅ **API REST**
- Endpoint público de configuración
- Actualizaciones en tiempo real
- Soporte para tokens de autenticación

---

## 📂 Estructura del Proyecto

```
radio-app-project/
├── android/                    # Código fuente de la app Android
│   ├── MainActivity.kt          # Actividad principal
│   ├── MusicService.kt          # Servicio de reproducción
│   ├── ConfigManager.kt         # Gestor de configuración
│   ├── SplashActivity.kt        # Pantalla de inicio
│   ├── build.gradle.kts         # Dependencias de Gradle
│   ├── AndroidManifest.xml      # Configuración de permisos
│   ├── activity_main.xml        # Layout principal
│   ├── activity_splash.xml      # Layout del splash
│   ├── strings.xml              # Textos de la app
│   ├── colors.xml               # Paleta de colores
│   ├── styles.xml               # Estilos y temas
│   └── *.xml (drawables)        # Fondos y botones
│
├── admin-panel/                 # Panel administrativo PHP
│   ├── index.php                # Dashboard principal
│   ├── login.php                # Página de login
│   ├── config.php               # Configuración
│   ├── classes/
│   │   ├── Auth.php             # Autenticación
│   │   └── ConfigManager.php    # Gestión de configuración
│   ├── api/
│   │   └── config.php           # Endpoint REST
│   ├── css/
│   │   ├── admin.css            # Estilos del panel
│   │   └── login.css            # Estilos del login
│   ├── js/
│   │   └── admin.js             # Funcionalidades JavaScript
│   └── uploads/                 # Carpeta para archivos subidos
│
├── database/                    # Base de datos
│   └── schema.sql               # Script SQL de creación
│
├── docs/                        # Documentación
│   └── GUIA_COMPLETA.md         # Guía completa de instalación
│
└── README.md                    # Este archivo
```

---

## 🚀 Inicio Rápido

### Requisitos Mínimos

- **Android Studio** 2023.1+
- **PHP 7.4+** (recomendado 8.0+)
- **MySQL 5.7+**
- **Java Development Kit 11+**
- **4 GB de RAM**

### Instalación Rápida

```bash
# 1. Clonar/descargar proyecto
cd radio-app-project

# 2. Configurar base de datos
mysql -u root -p < database/schema.sql

# 3. Subir panel al servidor
rsync -avz admin-panel/ usuario@servidor.com:/var/www/html/

# 4. Abrir proyecto en Android Studio
# File → Open → carpeta 'android'

# 5. Compilar APK
# Build → Build Bundle(s) / APK(s) → Build APK(s)
```

Para una guía detallada, ver [GUIA_COMPLETA.md](docs/GUIA_COMPLETA.md)

---

## 🔐 Seguridad

- ✅ Contraseñas encriptadas con bcrypt
- ✅ HTTPS obligatorio
- ✅ CORS habilitado para dominios específicos
- ✅ Validación de entrada en todos los formularios
- ✅ Protección contra SQL injection
- ✅ Tokens de API expirables
- ✅ Bloqueo de cuenta tras múltiples intentos fallidos

---

## 📱 Funcionalidades de la App

### Reproducción de Audio
```kotlin
// Iniciar reproducción
musicService?.play()

// Pausar
musicService?.pause()

// Detener
musicService?.stop()

// Cambiar stream
musicService?.setStreamUrl(newUrl)
```

### Obtener Configuración
```kotlin
// La app obtiene configuración automáticamente de:
GET https://tu-dominio.com/api/config

// Respuesta JSON
{
    "stationName": "Mi Radio",
    "streamUrl": "http://streaming.server.com:8000/",
    "primaryColor": "#FF6200EE",
    "secondaryColor": "#FF03DAC6",
    "logoUrl": "https://tu-dominio.com/logo.png",
    "facebookUrl": "https://facebook.com/mi-radio",
    "instagramUrl": "https://instagram.com/mi-radio",
    "tiktokUrl": "https://tiktok.com/@mi-radio",
    "whatsappUrl": "https://wa.me/1234567890"
}
```

---

## 🔧 Personalización

### Cambiar Colores

1. Ir a panel administrativo
2. Ir a "Configuración Visual"
3. Seleccionar colores
4. Guardar cambios

Los colores se actualizarán en la app automáticamente.

### Cambiar URL del Stream

1. Panel administrativo → "Información General"
2. Cambiar URL (ej: `http://streaming-server.com:8000/live`)
3. Guardar cambios

### Agregar Redes Sociales

1. Completa las URLs en la sección "Redes Sociales"
2. Formatos válidos:
   - Facebook: `https://facebook.com/tu-pagina`
   - Instagram: `https://instagram.com/tu-cuenta`
   - TikTok: `https://tiktok.com/@tu-cuenta`
   - WhatsApp: `https://wa.me/1234567890`

---

## 📊 Tecnologías Utilizadas

### Android
- **Kotlin** - Lenguaje principal
- **Jetpack** - AndroidX, Lifecycle, WorkManager
- **Retrofit** - Cliente HTTP
- **Glide** - Carga de imágenes
- **MediaPlayer** - Reproducción de audio

### Backend
- **PHP 8** - Lenguaje servidor
- **MySQL** - Base de datos
- **Retrofit** - API REST

### Frontend Admin
- **HTML5** - Estructura
- **CSS3** - Estilos modernos
- **JavaScript** - Interactividad
- **Font Awesome 6** - Iconos

---

## 📈 Estadísticas del Proyecto

- **Líneas de código Android**: ~800
- **Líneas de código PHP**: ~700
- **Líneas de código CSS**: ~900
- **Líneas de código SQL**: ~150
- **Total**: ~2,550 líneas

---

## 🐛 Solución de Problemas Comunes

### La app no se conecta
→ Verificar URL en `ConfigManager.kt`
→ Verificar que el servidor está disponible

### El panel de admin no carga
→ Verificar credenciales en `config.php`
→ Revisar logs de PHP

### La radio no suena
→ Verificar URL del stream con VLC
→ Comprobar firewall del servidor

Para más soluciones, ver [GUIA_COMPLETA.md](docs/GUIA_COMPLETA.md#solución-de-problemas)

---

## 📄 Licencia

Este proyecto está disponible bajo la licencia MIT.

---

## 👨‍💻 Autor

Desarrollado como una solución completa para aplicaciones de radio streaming.

---

## 🤝 Contribuciones

Las contribuciones son bienvenidas. Por favor:

1. Fork el proyecto
2. Crea una rama para tu feature (`git checkout -b feature/AmazingFeature`)
3. Commit tus cambios (`git commit -m 'Add some AmazingFeature'`)
4. Push a la rama (`git push origin feature/AmazingFeature`)
5. Abre un Pull Request

---

## 📞 Soporte

Para soporte técnico, consulta la [Guía Completa](docs/GUIA_COMPLETA.md) o contacta al desarrollador.

---

## 🎉 ¿Listo para empezar?

1. **Lee** [GUIA_COMPLETA.md](docs/GUIA_COMPLETA.md)
2. **Configura** tu servidor y base de datos
3. **Personaliza** la app con tus colores y datos
4. **Compila** el APK
5. **Publica** en Google Play Store

¡Buena suerte con tu estación de radio! 📻✨

---

**Última actualización**: 2024
**Versión actual**: 1.0.0
