<?php
/**
 * api/config.php
 * Endpoint REST para obtener configuración
 */

header('Content-Type: application/json; charset=utf-8');

// CORS
$allowed_origins = ['https://tu-dominio.com', 'https://app.tu-dominio.com'];
$origin = $_SERVER['HTTP_ORIGIN'] ?? '';

if (in_array($origin, $allowed_origins)) {
    header('Access-Control-Allow-Origin: ' . $origin);
    header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
    header('Access-Control-Allow-Headers: Content-Type, Authorization');
}

// Manejar OPTIONS
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

require_once(__DIR__ . '/../config.php');
require_once(__DIR__ . '/../classes/Auth.php');
require_once(__DIR__ . '/../classes/ConfigManager.php');

$response = ['success' => false, 'message' => 'Acceso denegado'];
http_response_code(403);

// Verificar método
if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    $response = ['success' => false, 'message' => 'Método no permitido'];
    http_response_code(405);
    echo json_encode($response);
    exit();
}

// Verificar token de API
$headers = getallheaders();
$token = $headers['Authorization'] ?? '';

// Eliminar "Bearer " del token si existe
if (strpos($token, 'Bearer ') === 0) {
    $token = substr($token, 7);
}

if (!empty($token)) {
    try {
        $stmt = $pdo->prepare('
            SELECT usuario_id FROM sesiones_api 
            WHERE token = ? AND activo = 1 AND fecha_expiracion > NOW()
        ');
        $stmt->execute([$token]);
        $session = $stmt->fetch();

        if ($session) {
            // Token válido, retornar configuración
            $configManager = new ConfigManager($pdo, null);
            $config = $configManager->exportarJSON();

            if ($config) {
                http_response_code(200);
                echo json_encode([
                    'success' => true,
                    'data' => $config
                ]);
            } else {
                http_response_code(500);
                echo json_encode([
                    'success' => false,
                    'message' => 'No hay configuración disponible'
                ]);
            }
            exit();
        }
    } catch (Exception $e) {
        // Token inválido
    }
}

// Permitir acceso público a la configuración
try {
    $configManager = new ConfigManager($pdo, null);
    $config = $configManager->exportarJSON();

    if ($config) {
        http_response_code(200);
        echo json_encode([
            'success' => true,
            'data' => $config
        ]);
    } else {
        http_response_code(500);
        echo json_encode([
            'success' => false,
            'message' => 'No hay configuración disponible'
        ]);
    }
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Error al obtener configuración'
    ]);
}
?>
