<?php
/**
 * config.php
 * Configuración de conexión a base de datos
 */

// Configuración de la base de datos
define('DB_HOST', 'localhost');
define('DB_USER', 'radio_user');
define('DB_PASS', 'password_seguro_123');
define('DB_NAME', 'radio_admin');

// Configuración general
define('BASE_URL', 'https://tu-dominio.com/admin/');
define('APP_NAME', 'RadioApp Admin Panel');
define('APP_VERSION', '1.0.0');

// Configuración de seguridad
define('JWT_SECRET', 'tu_clave_secreta_muy_segura_aqui_cambiar');
define('SESSION_TIMEOUT', 3600); // 1 hora
define('MAX_LOGIN_ATTEMPTS', 5);
define('LOCKOUT_TIME', 900); // 15 minutos

// Configuración de API
define('API_BASE_URL', BASE_URL . 'api/');
define('CORS_ORIGINS', ['https://tu-dominio.com', 'https://app.tu-dominio.com']);

// Configuración de archivos
define('UPLOAD_DIR', __DIR__ . '/uploads/');
define('ALLOWED_EXTENSIONS', ['jpg', 'jpeg', 'png', 'gif', 'mp3', 'wav']);
define('MAX_FILE_SIZE', 50 * 1024 * 1024); // 50MB

// Configuración de logging
define('LOG_DIR', __DIR__ . '/logs/');
define('LOG_LEVEL', 'INFO'); // DEBUG, INFO, WARNING, ERROR

// Modo desarrollo
define('DEBUG_MODE', false);

// Error reporting
if (DEBUG_MODE) {
    error_reporting(E_ALL);
    ini_set('display_errors', 1);
} else {
    error_reporting(0);
    ini_set('display_errors', 0);
    ini_set('log_errors', 1);
    ini_set('error_log', LOG_DIR . 'php_errors.log');
}

// Headers de seguridad
header('X-Content-Type-Options: nosniff');
header('X-Frame-Options: SAMEORIGIN');
header('X-XSS-Protection: 1; mode=block');
header('Referrer-Policy: strict-origin-when-cross-origin');

try {
    // Crear conexión a base de datos
    $pdo = new PDO(
        'mysql:host=' . DB_HOST . ';dbname=' . DB_NAME . ';charset=utf8mb4',
        DB_USER,
        DB_PASS,
        [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES => false,
        ]
    );
} catch (PDOException $e) {
    if (DEBUG_MODE) {
        die('Error de conexión: ' . $e->getMessage());
    } else {
        die('Error de conexión a la base de datos');
    }
}

// Iniciar sesión
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
?>
