<?php
/**
 * login.php
 * Página de autenticación
 */

require_once('config.php');
require_once('classes/Auth.php');

$auth = new Auth($pdo);

// Si ya está autenticado, ir al dashboard
if ($auth->isAuthenticated()) {
    header('Location: index.php');
    exit();
}

$error = '';
$message = '';

// Procesar logout anterior
if (isset($_GET['logout'])) {
    $auth->logout();
}

// Mostrar mensaje de sesión expirada
if (isset($_GET['msg']) && $_GET['msg'] === 'session_expired') {
    $message = 'Tu sesión ha expirado. Por favor inicia sesión de nuevo.';
}

// Procesar formulario de login
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Verificar si está bloqueado
    if ($auth->isLoginBlocked()) {
        $error = 'Demasiados intentos fallidos. Intenta más tarde.';
    } else {
        $email = $_POST['email'] ?? '';
        $password = $_POST['password'] ?? '';

        $resultado = $auth->login($email, $password);
        if ($resultado['success']) {
            header('Location: index.php');
            exit();
        } else {
            $error = $resultado['message'];
        }
    }
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - <?php echo APP_NAME; ?></title>
    <link rel="stylesheet" href="css/login.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body>
    <div class="login-container">
        <div class="login-box">
            <div class="login-header">
                <div class="logo-icon">
                    <i class="fas fa-radio"></i>
                </div>
                <h1><?php echo APP_NAME; ?></h1>
                <p>Panel de Administración</p>
            </div>

            <?php if ($error): ?>
            <div class="alert alert-error">
                <i class="fas fa-exclamation-circle"></i>
                <?php echo htmlspecialchars($error); ?>
            </div>
            <?php endif; ?>

            <?php if ($message): ?>
            <div class="alert alert-info">
                <i class="fas fa-info-circle"></i>
                <?php echo htmlspecialchars($message); ?>
            </div>
            <?php endif; ?>

            <form method="POST" class="login-form">
                <div class="form-group">
                    <label for="email">
                        <i class="fas fa-envelope"></i> Correo Electrónico
                    </label>
                    <input type="email" id="email" name="email" 
                           placeholder="admin@radioapp.com" 
                           required 
                           class="form-control">
                </div>

                <div class="form-group">
                    <label for="password">
                        <i class="fas fa-lock"></i> Contraseña
                    </label>
                    <input type="password" id="password" name="password" 
                           placeholder="Ingresa tu contraseña" 
                           required 
                           class="form-control">
                </div>

                <div class="form-group">
                    <label class="remember-me">
                        <input type="checkbox" name="remember" id="remember">
                        <span>Recuérdame</span>
                    </label>
                </div>

                <button type="submit" class="btn btn-login">
                    <i class="fas fa-sign-in-alt"></i> Iniciar Sesión
                </button>
            </form>

            <div class="login-footer">
                <p>¿Primera vez? Contacta al administrador para obtener credenciales.</p>
                <p class="version">v<?php echo APP_VERSION; ?></p>
            </div>
        </div>
    </div>

    <script>
        // Animación simple
        document.addEventListener('DOMContentLoaded', function() {
            const form = document.querySelector('.login-form');
            form.addEventListener('submit', function() {
                const button = this.querySelector('button');
                button.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Autenticando...';
                button.disabled = true;
            });
        });
    </script>
</body>
</html>
