# ❓ Preguntas Frecuentes (FAQ)

## 📲 Preguntas sobre la Aplicación Android

### P: ¿Qué versión de Android es compatible?
**R:** Android 5.1 (API 21) en adelante. Recomendamos Android 10 o superior para mejor rendimiento.

### P: ¿Cuánto espacio necesita la app?
**R:** Aproximadamente 15-20 MB. Requiere conexión a Internet.

### P: ¿Consume mucho datos?
**R:** Depende de la calidad del stream (128 kbps = ~57 MB/hora, 192 kbps = ~86 MB/hora).

### P: ¿Funciona sin conexión a Internet?
**R:** No, requiere conexión a Internet para reproducir el stream.

### P: ¿Puedo usar la app en tablets?
**R:** Sí, está optimizada para teléfonos pero funciona en tablets.

### P: ¿Cómo cambio los colores de la app?
**R:** Desde el panel administrativo, sección "Diseño Visual". Los cambios se reflejan automáticamente.

---

## 🌐 Preguntas sobre el Panel Administrativo

### P: ¿Olvidé mi contraseña?
**R:** Ejecuta el script de reset (ver documentación) o reinstala la base de datos.

### P: ¿Cuántos usuarios pueden acceder?
**R:** Ilimitados. Puedes crear múltiples usuarios desde el panel.

### P: ¿Se pueden hacer cambios sin reiniciar la app?
**R:** Sí, los cambios de configuración se aplican en tiempo real.

### P: ¿Dónde se guardan los archivos subidos?
**R:** En la carpeta `/uploads` del servidor (personalizable en config.php).

### P: ¿Qué tamaño máximo de imagen puedo subir?
**R:** Máximo 50 MB (configurable en config.php).

### P: ¿Puedo exportar la configuración?
**R:** Sí, hay un botón para descargar JSON en el panel.

---

## 🔧 Problemas Técnicos

### P: "La app no se conecta al servidor"
**R:**
1. Verifica la URL en `ConfigManager.kt`
2. Asegúrate que el servidor está en línea
3. Prueba desde el navegador: `https://tu-dominio.com/api/config`
4. Revisa el firewall del servidor

```bash
# Verificar disponibilidad
curl -I https://tu-dominio.com/api/config
```

### P: "Error de autenticación en el panel"
**R:**
1. Verifica que introduciste el email y contraseña correctos
2. Espera 15 minutos si hay bloqueo por intentos fallidos
3. Revisa que no está con mayúsculas bloqueada
4. Verifica los logs: `admin-panel/logs/php_errors.log`

### P: "El logo no se actualiza en la app"
**R:**
1. Borra caché de la aplicación
2. Asegúrate que la URL del archivo es correcta
3. Intenta desinstalar y reinstalar la app
4. Revisa la consola de desarrollo

### P: "La radio no suena"
**R:**
1. Verifica que el stream está en línea
   ```bash
   curl -I http://servidor:8000/stream
   ```
2. Prueba la URL con VLC Media Player
3. Revisa que el volumen del dispositivo está ON
4. Comprueba los permisos de audio

### P: "Error 500 en el panel"
**R:**
1. Verifica que PHP está activo
2. Revisa los logs: `/var/log/php-fpm.log`
3. Verifica conexión a MySQL:
   ```bash
   mysql -u radio_user -p radio_admin -e "SELECT 1;"
   ```
4. Comprueba permisos de carpetas

### P: "Base de datos no accesible"
**R:**
1. Verifica que MySQL está corriendo
   ```bash
   systemctl status mysql
   ```
2. Verifica credenciales en `config.php`
3. Prueba conexión:
   ```bash
   mysql -u radio_user -p radio_admin
   ```

### P: "Error de SSL/HTTPS"
**R:**
1. Verifica que tienes certificado válido
   ```bash
   certbot certificates
   ```
2. Renueva si es necesario:
   ```bash
   certbot renew
   ```
3. Revisa configuración de nginx/apache

---

## 📱 Distribución y Publicación

### P: ¿Puedo publicar la app en Google Play Store?
**R:** Sí, necesitas:
- Cuenta Google Play Developer ($25)
- APK compilado en release
- Política de privacidad
- Capturas de pantalla

### P: ¿Cuánto cuesta publicar?
**R:** Google Play Store cobra una tarifa única de $25 USD.

### P: ¿Cuánto tiempo tarda la aprobación?
**R:** Típicamente 24-72 horas. Google revisa:
- Funcionalidad
- Seguridad
- Permisos
- Contenido

### P: ¿Puedo distribuir sin Google Play Store?
**R:** Sí, puedes:
- Distribuir APK directamente
- Usar tiendas alternativas
- Pero no aparecerá en Google Play

### P: ¿Cómo hago un APK de prueba?
**R:**
```bash
# APK Debug (solo para pruebas)
./gradlew assembleDebug

# Instalar en dispositivo
adb install app/build/outputs/apk/debug/app-debug.apk
```

### P: ¿Es necesario "Release" para Google Play?
**R:** Sí, es obligatorio compilar en modo Release con firma.

---

## 💰 Costos y Limitaciones

### P: ¿Cuál es el costo total?
**R:**
- Dominio: $10-15/año
- Hosting: $3-50/mes
- Google Play Store: $25 (único)
- Total inicial: ~$50 (hosting 1 año + Play Store)

### P: ¿Cuántos usuarios simultáneos soporta?
**R:** Depende de tu servidor y ancho de banda.
- 100 usuarios: 12.8 Mbps (128 kbps)
- 1,000 usuarios: 128 Mbps

### P: ¿Hay límite de configuraciones?
**R:** No, puedes cambiar ilimitadamente desde el panel.

---

## 🔒 Seguridad

### P: ¿Es seguro el panel administrativo?
**R:** Sí, incluye:
- Autenticación bcrypt
- HTTPS obligatorio
- Protección CSRF
- Validación de entrada
- Logs de cambios

### P: ¿Cómo cambio la contraseña?
**R:** En la base de datos (hash bcrypt):
```php
$hash = password_hash('nueva_contraseña', PASSWORD_BCRYPT);
```

### P: ¿Qué datos se guardan en la app?
**R:** Solo:
- Configuración (colores, URLs, nombre)
- Preferencias locales
- No se guardan datos personales

### P: ¿Puedo usar HTTP en lugar de HTTPS?
**R:** No recomendado en producción. Google Play rechaza apps inseguras.

---

## 📊 Estadísticas y Monitoreo

### P: ¿Cómo veo los usuarios activos?
**R:** Los logs están en:
- `/admin-panel/logs/access.log` (web)
- Historial en la base de datos

### P: ¿Puedo ver cuántas personas usan la app?
**R:** No directamente. Puedes:
- Usar Google Analytics
- Google Play Console (estadísticas)
- Logs del servidor (conexiones)

### P: ¿Dónde veo los errores?
**R:** Revisa:
- `admin-panel/logs/php_errors.log`
- `/var/log/nginx/error.log`
- Consola de Android Studio (adb logcat)

---

## 🎓 Aprendizaje y Desarrollo

### P: ¿Puedo modificar el código?
**R:** Sí, todo el código está disponible. Debes conocer:
- Kotlin (Android)
- PHP (backend)
- SQL (base de datos)

### P: ¿Dónde aprendo sobre Shoutcast/Icecast?
**R:** Sitios útiles:
- Shoutcast: https://www.shoutcast.com
- Icecast: https://icecast.org
- OBS Studio: https://obsproject.com (para streaming)

### P: ¿Cómo agrego más funciones?
**R:** Puedes:
- Editar layouts XML (UI)
- Agregar servicios Kotlin (funcionalidad)
- Crear nuevos endpoints PHP (API)

---

## 🚀 Optimización

### P: ¿Cómo mejoro la velocidad?
**R:**
- Comprime el APK
- Usa CDN para archivos estáticos
- Implementa caché
- Optimiza imágenes

### P: ¿Cómo bajo el consumo de datos?
**R:**
- Usa bitrate más bajo en stream
- Implementa compresión
- Caché de metadatos

### P: ¿Cómo mejoro la batería?
**R:**
- Usa WorkManager para tareas
- Implementa sleep inteligente
- Reduce actualizaciones

---

## 📞 Contacto y Soporte

### P: ¿Dónde obtengo soporte?
**R:** Consulta:
1. [GUIA_COMPLETA.md](GUIA_COMPLETA.md)
2. Documentación oficial de Android
3. Stack Overflow para problemas específicos

### P: ¿Hay versión de demostración?
**R:** Sí, puedes:
- Compilar en debug
- Usar simulador
- Probar con datos de ejemplo

### P: ¿Qué hacer si encuentro un bug?
**R:**
1. Documenta los pasos
2. Revisa los logs
3. Crea un reporte detallado
4. Incluye versión y dispositivo

---

## ✅ Checklist Pre-Publicación

Antes de publicar en Play Store, verifica:

- [ ] APK compilado en Release
- [ ] Versión correcta en versionCode
- [ ] Icono de app (512x512)
- [ ] Capturas de pantalla (4-8)
- [ ] Descripción breve y larga
- [ ] Política de privacidad
- [ ] Categoría seleccionada
- [ ] Clasificación de contenido completada
- [ ] Email de soporte
- [ ] Sitio web de la empresa
- [ ] Permisos justificados
- [ ] Probado en múltiples dispositivos

---

**¿No encontraste tu pregunta?**

Consulta la documentación completa en [GUIA_COMPLETA.md](GUIA_COMPLETA.md) o contacta al equipo de soporte.

---

**Última actualización**: 2024
**Versión**: 1.0.0
