# RadioApp - Guía Completa de Instalación y Publicación

## 📋 Tabla de Contenidos
1. [Requisitos](#requisitos)
2. [Instalación](#instalación)
3. [Configuración](#configuración)
4. [Compilación de APK](#compilación-de-apk)
5. [Publicación en Google Play Store](#publicación-en-google-play-store)
6. [Configuración del Panel Administrativo](#configuración-del-panel-administrativo)
7. [Solución de Problemas](#solución-de-problemas)

---

## 📦 Requisitos

### Para la Aplicación Android:
- **Android Studio** (versión 2023.1 o superior)
- **JDK 11** o superior
- **SDK de Android** 34+ (mínimo SDK 21)
- **Gradle 8.0** o superior
- **Git** (opcional, pero recomendado)
- 4 GB de RAM mínimo
- Espacio en disco: 10 GB

### Para el Panel Administrativo:
- **Servidor Web** (Apache, Nginx)
- **PHP 7.4** o superior (recomendado PHP 8.x)
- **MySQL 5.7** o superior (PostgreSQL es compatible)
- **Composer** (gestor de dependencias PHP)
- **OpenSSL** habilitado en PHP

---

## 🚀 Instalación

### PASO 1: Descargar y Preparar el Proyecto

```bash
# Clonar o descargar el proyecto
cd /ruta/del/proyecto

# Verificar la estructura de carpetas
ls -la
# Debe mostrar: android, admin-panel, database, docs
```

### PASO 2: Instalación de Android Studio

1. Descargar desde: https://developer.android.com/studio
2. Instalar siguiendo el asistente
3. Abrir Android Studio
4. Ir a Tools → SDK Manager
5. Instalar:
   - Android SDK 34
   - SDK Build-Tools 34.x
   - Android Emulator
   - Android SDK Platform-Tools

### PASO 3: Preparar Proyecto Android

```bash
# Navegar a la carpeta del proyecto Android
cd android

# Abrir el proyecto en Android Studio
# File → Open → Seleccionar carpeta "android"

# Android Studio descargará automáticamente Gradle
# Esperar a que se complete la sincronización
```

---

## ⚙️ Configuración

### Configuración Android

#### 1. Actualizar la URL del API (IMPORTANTE)

Editar archivo: `android/ConfigManager.kt`

```kotlin
companion object {
    fun getApiBaseUrl(): String {
        return "https://tu-dominio.com/"  // ← Cambiar aquí
    }
}
```

#### 2. Crear archivo de configuración de compilación

Crear archivo: `android/local.properties`
```properties
sdk.dir=/path/to/android/sdk
ndk.dir=/path/to/android/ndk
```

#### 3. Configurar identidad de la aplicación

Editar: `android/build.gradle.kts`
```kotlin
defaultConfig {
    applicationId = "com.tu-empresa.radioapp"  // Cambiar
    versionCode = 1
    versionName = "1.0.0"
}
```

---

### Configuración del Panel Administrativo

#### 1. Instalación de Base de Datos

```bash
# Conectar a MySQL
mysql -u root -p

# Ejecutar el script SQL
mysql> source /ruta/al/database/schema.sql;

# Verificar creación
mysql> USE radio_admin;
mysql> SHOW TABLES;
```

#### 2. Configurar PHP

Crear archivo: `admin-panel/config.php`

```php
define('DB_HOST', 'localhost');
define('DB_USER', 'radio_user');        // Cambiar
define('DB_PASS', 'password_seguro');   // Cambiar
define('DB_NAME', 'radio_admin');
define('BASE_URL', 'https://tu-dominio.com/admin/');
define('JWT_SECRET', 'clave_super_secreta_aqui');
```

#### 3. Subir archivos al servidor

```bash
# Usando SFTP o FTP
sftp usuario@tu-servidor.com
put -r admin-panel /var/www/html/

# O usando rsync
rsync -avz admin-panel/ usuario@tu-servidor.com:/var/www/html/admin-panel/
```

#### 4. Establecer permisos

```bash
# En el servidor
chmod 755 /var/www/html/admin-panel
chmod 644 /var/www/html/admin-panel/*.php
chmod 755 /var/www/html/admin-panel/uploads
chmod 755 /var/www/html/admin-panel/logs
chmod 644 /var/www/html/admin-panel/css/*
chmod 644 /var/www/html/admin-panel/js/*
```

#### 5. Crear usuario administrador

```bash
# Crear script: admin-panel/setup.php
<?php
require_once('config.php');
require_once('classes/Auth.php');

$auth = new Auth($pdo);
$resultado = $auth->register(
    'Administrador',
    'admin@turadio.com',
    'tu_password_seguro_aqui',
    'admin'
);

if ($resultado['success']) {
    echo "Usuario creado correctamente";
} else {
    echo "Error: " . $resultado['message'];
}
?>

# Ejecutar desde navegador (luego eliminar)
# https://tu-dominio.com/admin-panel/setup.php
```

---

## 🛠️ Compilación de APK

### Método 1: Android Studio (Recomendado para principiantes)

1. **Abrir Android Studio**
   - File → Open
   - Seleccionar carpeta `android`

2. **Esperar sincronización**
   - Gradle se sincronizará automáticamente

3. **Compilar APK**
   - Build → Build Bundle(s) / APK(s) → Build APK(s)
   - Esperar a que termine
   - Se guardará en: `android/app/build/outputs/apk/debug/`

4. **Compilar APK optimizado para Play Store (Release)**
   - Build → Generate Signed Bundle / APK
   - Seleccionar APK
   - Crear/Seleccionar llave
   - Seleccionar "release"
   - Guardar en ubicación segura

### Método 2: Línea de Comandos

```bash
cd android

# APK de Debug
./gradlew assembleDebug
# Salida: app/build/outputs/apk/debug/app-debug.apk

# APK de Release (requiere keystore)
./gradlew assembleRelease
# Salida: app/build/outputs/apk/release/app-release.apk
```

### Crear Firma (Keystore) para Release

```bash
# Crear keystore
keytool -genkey -v -keystore radioapp.keystore \
    -keyalg RSA -keysize 2048 -validity 10000 \
    -alias radioapp

# Información a rellenar:
# - Contraseña: (elegir contraseña segura)
# - Nombre: Tu Nombre
# - Organización: Tu Organización
# - Ciudad: Tu Ciudad
# - Provincia: Tu Provincia
# - País: TU (código de 2 letras)

# Guardar radioapp.keystore en lugar seguro (¡NO PERDER!)
```

---

## 🎯 Publicación en Google Play Store

### PASO 1: Crear Cuenta Google Play Developer

1. Ir a https://play.google.com/console
2. Crear cuenta de Google Play Developer ($25 USD)
3. Aceptar los términos

### PASO 2: Crear Nueva Aplicación

1. Crear nueva aplicación
2. Nombre de la aplicación: "RadioApp" (o tu nombre)
3. Seleccionar categoría: "Música y Audio"
4. Ir a Tienda → Información sobre la aplicación

### PASO 3: Completar Información de la Tienda

#### Descripción de la Aplicación
```
Escucha tu estación de radio favorita en vivo. 
RadioApp es una aplicación moderna con streaming 
de alta calidad compatible con Shoutcast e Icecast.

Características:
- Reproducción de audio en vivo
- Interfaz intuitiva y moderna
- Redes sociales integradas
- Bajo consumo de datos
```

#### Gráficos

- **Icono de aplicación** (512x512px)
  - Crear logo.png
  - Usar herramienta: https://www.androidcodelab.com/app-icon-generator/

- **Imágenes en la tienda** (4 mínimo, máx 8)
  - 1080 x 1920px (portada vertical)
  - Crear screenshots de la app en diferentes estados

- **Imagen destacada**
  - 1024 x 500px

### PASO 4: Información Técnica

#### Privacidad
- Completar formulario de privacidad
- Política de privacidad URL

#### Clasificación de contenido
- Responder cuestionario de contenido

#### Permisos
- Revisar permisos automáticamente detectados

### PASO 5: Subir APK

1. Ir a Versiones → Crear versión de prueba
2. Click en "Cargar"
3. Seleccionar APK compilado (release)
4. Rellenar:
   - Notas de la versión
   - Nombre de la versión
5. Guardar como borrador

### PASO 6: Revisar y Publicar

1. Revisar toda la información
2. Aceptar formularios de certificación
3. Enviar para revisión
4. Google Play revisará (típicamente 24-72 horas)
5. Si es aprobado, la app será publicada

---

## 🔧 Configuración del Panel Administrativo

### Primer acceso

1. Ir a: https://tu-dominio.com/admin-panel/
2. Usar credenciales:
   - Email: admin@turadio.com
   - Contraseña: (la que creaste en setup.php)

### Configurar la aplicación

1. **Llenar información de estación**
   - Nombre de la estación
   - Descripción
   - URL del stream

2. **Configurar colores**
   - Color primario: (ej: #6200EE)
   - Color secundario: (ej: #03DAC6)

3. **Subir logo**
   - Imagen PNG o JPG (máx 5MB)

4. **Configurar redes sociales**
   - Facebook, Instagram, TikTok, WhatsApp
   - Con URLs completas

5. **Guardar cambios**
   - Los cambios se reflejarán en la app en tiempo real

---

## 🌐 Conectar App con Panel (URL API)

### En Android Studio

1. Editar: `ConfigManager.kt`

```kotlin
companion object {
    fun getApiBaseUrl(): String {
        return "https://tu-dominio.com/"  // URL DEL SERVIDOR
    }
}
```

2. La app obtendrá la configuración de:
   ```
   https://tu-dominio.com/api/config
   ```

3. Compilar nuevo APK con esta configuración

---

## 🔒 Seguridad y Mejores Prácticas

### Proteger el Panel Administrativo

```bash
# En .htaccess (Apache)
<Files config.php>
    Deny from all
</Files>

# Cambiar credenciales por defecto
# En config.php, cambiar todas las contraseñas y claves

# Habilitar HTTPS (obligatorio)
# Usar certificado SSL (Let's Encrypt es gratuito)
```

### Actualizar credenciales en Android

```kotlin
// En BuildConfig o constants
const val API_BASE_URL = "https://tu-dominio.com/"
const val API_TIMEOUT = 10  // segundos
```

---

## 📱 Probar Antes de Publicar

### En Emulador

1. Crear emulador Android en Android Studio
2. Ejecutar app: Run → Run 'app'
3. Probar todas las funciones:
   - Reproducción de radio
   - Cambio de colores
   - Botones de redes sociales

### En Dispositivo Real

```bash
# Conectar dispositivo USB
adb devices  # Verificar que aparece el dispositivo

# Instalar app
adb install app/build/outputs/apk/debug/app-debug.apk

# Ver logs
adb logcat
```

---

## ❓ Solución de Problemas

### La app no se conecta al servidor

**Problema:** "Error al obtener configuración"

**Soluciones:**
1. Verificar URL en `ConfigManager.kt`
2. Verificar que el servidor está en línea
3. Revisar logs: `admin-panel/logs/php_errors.log`
4. Usar Postman para probar: `GET https://tu-dominio.com/api/config`

### El panel no carga

**Problema:** Página en blanco o error 500

**Soluciones:**
```bash
# Verificar logs PHP
tail -f /var/log/apache2/error.log

# Verificar conexión MySQL
mysql -u radio_user -p radio_admin

# Verificar permisos
ls -la /var/www/html/admin-panel/
```

### La radio no se reproduce

**Problema:** Error de reproducción

**Soluciones:**
1. Verificar URL del stream:
   ```bash
   curl -I http://streaming-server:8000/stream
   ```
2. Usar test player (VLC, WinAmp)
3. Revisar firewall del servidor

### Error "Aplicación no instalada"

**Problema:** No puede instalar APK

**Soluciones:**
1. Verificar que es versión correcta
2. Desinstalar versión anterior
3. Usar comandos adb:
   ```bash
   adb uninstall com.radioapp.streaming
   adb install app-release.apk
   ```

---

## 📞 Soporte Técnico

Para problemas específicos:

1. Verificar logs del servidor
2. Revisar documentación oficial:
   - Android Developers: https://developer.android.com
   - Google Play Console: https://play.google.com/console
   - PHP Manual: https://www.php.net/manual

3. Validar APK:
   ```bash
   jarsigner -verify -certs app-release.apk
   ```

---

## 🎉 ¡Listo!

Tu aplicación de radio está lista para publicar. 

**Próximos pasos:**
- [ ] Compilar APK final
- [ ] Probarlo en dispositivo
- [ ] Configurar panel administrativo
- [ ] Enviar a Google Play Store
- [ ] Esperar aprobación
- [ ] Publicar

¡Buena suerte! 🚀
